﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage" %>
<%@ Import Namespace="Microsoft.Samples.PlanMyNight.Entities" %>
<% var itinerary = (Itinerary)ViewData.Model; %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=8" />
    <% if(!string.IsNullOrEmpty(itinerary.Name)) { %>
        <title>Plan My Night - <%:itinerary.Name%></title>
    <% } else { %>
        <title>Plan My Night - My Itinerary</title>
    <% } %>
    <style type="text/css">
    body {
    	font-family: Verdana, Arial, Sans-Serif;
    	font-size: 14px;
	    width: auto;  margin: 3%; padding: 0; 
	    color: black; 
	    background: transparent;
    }
    
    h1, h2, h3, h4, h5, h6 { margin: 0; padding: 0; }
    p { margin: 0; padding: .25em 0;  }
    ol { border-top: 2px solid black; padding-top: 2em; }
    ol li { padding-bottom: 1em; }
    
    </style>
</head>
<body onload="window.print()">
    <h1>Plan My Night</h1>
    <h2><%:itinerary.Name%></h2>
    <p><%:itinerary.Description%></p>

    <ol class="activities">
    <% foreach (var item in itinerary.Activities) %>
    <% { %>
        <li>
            <h3><%:item.Activity.Name%></h3>
            <p>
                <%:item.Activity.Street%><br />
                <%:item.Activity.City%>, <%:item.Activity.State%>
                <%:item.Activity.Zip%><br />
                Phone: <%:item.Activity.PhoneNumber%>
            <% if (item.EstimatedMinutes > 0)
               { %>
                <br />Estimated remain time: <%:item.EstimatedMinutes%> minutes.
            <% } %>
            </p>
        </li>
    <% } %>
    </ol>
</body>
</html>